<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\ProductVariants\Transformer\XC\ProductVariants\Model\ProductVariant\Logic\Entity\Storefront;

use XC\ProductVariants\Model\ProductVariant as Source;
use XCart\Logic\Entity\Storefront\Image;
use XCart\Logic\Entity\Storefront\ProductVariant as Target;
use XCart\Factory\Logic\Entity\Storefront\ProductVariantInterface as Factory;
use XCart\Logic\Entity\Storefront\VariantAttribute;

class ProductVariant implements ProductVariantInterface
{
    public function __construct(
        private Factory $factory
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->factory->create();

        $target
            ->setId($input->getId())
            ->setSku($input->getDisplaySku())
            ->setPrice($input->getClearPrice())
            ->setAmount($input->getPublicAmount())
            ->setWeight($input->getClearWeight())
            ->setImage($this->getTransformedVariantImage($input))
            ->setAttributes($this->getTransformedAttributes($input))
            ->setIsDefault($input->getDefaultValue());

        return $target;
    }

    private function getTransformedVariantImage(\XC\ProductVariants\Model\ProductVariant $inputVariant): ?Image
    {
        /** @var \XC\ProductVariants\Model\Image\ProductVariant\Image $inputVariantImage */
        if ($inputVariantImage = $inputVariant->getImage()) {
            return (new Image())
                ->setUrl($inputVariantImage->getURL())
                ->setWidth($inputVariantImage->getWidth())
                ->setHeight($inputVariantImage->getHeight())
                ->setAlt($inputVariantImage->getAlt());
        }

        return null;
    }

    /**
     * @return VariantAttribute[]
     */
    private function getTransformedAttributes(\XC\ProductVariants\Model\ProductVariant $inputVariant): array
    {
        $transformedVariantAttributes = [];

        /** @var \XLite\Model\AttributeValue\AttributeValueSelect $value */
        foreach ($inputVariant->getValues() as $inputVariantAttributeValue) {
            $attribute = $inputVariantAttributeValue->getAttribute();

            $transformedVariantAttributes[] = (new VariantAttribute())
                ->setId($attribute->getId())
                ->setName($attribute->getName())
                ->setValue((string) $inputVariantAttributeValue->asString());
        }

        return $transformedVariantAttributes;
    }
}
