<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\ProductVariants;

use Symfony\Component\DependencyInjection\Compiler\PassConfig;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Bundle\Bundle;
use XC\ProductVariants\DependencyInjection\Compiler\AddCallForPriceFieldsForProductVariantPass;
use XC\ProductVariants\DependencyInjection\Compiler\AddSaleFieldsForProductVariantPass;
use XC\ProductVariants\DependencyInjection\Compiler\AddSystemFieldsForProductVariantPass;
use XC\ProductVariants\DependencyInjection\Compiler\AddWholesaleFieldsForProductVariantPass;
use XC\ProductVariants\DependencyInjection\Compiler\RegisterProductTransformerDecoratorBySaleBundlePass;
use XC\ProductVariants\DependencyInjection\Compiler\RegisterProductVariantTransformerDecoratorBySaleBundlePass;
use XC\ProductVariants\DependencyInjection\Compiler\RegisterProductTransformerDecoratorByCallForPriceBundlePass;
use XC\ProductVariants\DependencyInjection\Compiler\RegisterProductVariantTransformerDecoratorByCallForPriceBundlePass;
use XC\ProductVariants\DependencyInjection\Compiler\RegisterProductVariantTransformerDecoratorBySystemFieldsBundlePass;
use XC\ProductVariants\DependencyInjection\Compiler\RegisterProductGetOneActionDecoratorByWholesaleBundlePass;

final class ProductVariantsBundle extends Bundle
{
    public function build(ContainerBuilder $container): void
    {
        parent::build($container);

        $bundles = $container->getParameter('kernel.bundles');

        if (isset($bundles['SaleBundle'])) {
            $container->addCompilerPass(new AddSaleFieldsForProductVariantPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 710);
            $container->addCompilerPass(new RegisterProductTransformerDecoratorBySaleBundlePass());
            $container->addCompilerPass(new RegisterProductVariantTransformerDecoratorBySaleBundlePass());
        }

        if (isset($bundles['CallForPriceBundle'])) {
            $container->addCompilerPass(new AddCallForPriceFieldsForProductVariantPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 710);
            $container->addCompilerPass(new RegisterProductTransformerDecoratorByCallForPriceBundlePass());
            $container->addCompilerPass(new RegisterProductVariantTransformerDecoratorByCallForPriceBundlePass());
        }

        if (isset($bundles['SystemFieldsBundle'])) {
            $container->addCompilerPass(new AddSystemFieldsForProductVariantPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 710);
            $container->addCompilerPass(new RegisterProductVariantTransformerDecoratorBySystemFieldsBundlePass());
        }

        if (isset($bundles['WholesaleBundle'])) {
            $container->addCompilerPass(new AddWholesaleFieldsForProductVariantPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 710);
            $container->addCompilerPass(new RegisterProductGetOneActionDecoratorByWholesaleBundlePass());
        }
    }
}
