<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\ProductVariants\Module\QSL\CallForPrice\Transformer\XC\ProductVariants\Model\ProductVariant\Logic\Entity\Storefront;

use XC\ProductVariants\Transformer\XC\ProductVariants\Model\ProductVariant\Logic\Entity\Storefront\ProductVariantInterface;
use XC\ProductVariants\Model\ProductVariant as Source;
use XCart\Logic\Entity\Storefront\ProductVariant as Target;

class ProductVariantDecorator implements ProductVariantInterface
{
    public function __construct(
        private ProductVariantInterface $inner
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->inner->transform($input);

        $callForPrice = $input->getCallForPrice();

        $target->setCallForPrice($callForPrice);

        if ($callForPrice) {
            $target->setPrice(null);
        }

        return $target;
    }
}
