<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ProductVariants\Module\CDev\Wholesale\Logic\Action\Storefront\Product\GetOne;

use CDev\Wholesale\Transformer\CDev\Wholesale\Model\WholesalePrice\Logic\Entity\Storefront\WholesalePriceInterface as WholesalePriceTransformer;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DataSourceInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Action\Storefront\Product\GetOne\Assembler\QueryBuilder\FindOneQueryBuilderAssemblerInterface;
use XCart\Logic\Action\Storefront\Product\GetOne\DTO\Response as GetOneProductResponse;
use XCart\Logic\Entity\Storefront\Product as ProductLogicDto;

class ActionDecorator implements ActionInterface
{
    public function __construct(
        private ActionInterface $inner,
        private FindOneQueryBuilderAssemblerInterface $queryBuilderAssembler,
        private WholesalePriceTransformer $wholesalePriceTransformer,
        private DataSourceInterface $variantDataSource,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        $response = $this->inner->run($request);

        if ($response instanceof GetOneProductResponse) {
            /** @var ProductLogicDto $payload */
            $payload = $response->getPayload();

            $qb           = $this->queryBuilderAssembler->assemble($request);
            $productModel = $qb->getQuery()->getOneOrNullResult();

            $productModel->setWholesaleMembership(
                $request->getProfile()?->getMembership()
            );

            foreach ($payload->getVariants() as $productVariantLogicDto) {
                $productVariantModel = $this->variantDataSource->findOne($productVariantLogicDto->getId());

                if ($productVariantModel?->isWholesalePricesEnabled()) {
                    if ($productVariantModel->getDefaultPrice()) {
                        $variantWholeSalePrices = null;
                    } else {
                        $variantWholeSalePrices = [];

                        foreach ($productVariantModel->getPreparedWholesalePricesForCurrentMembership() as $wholesalePrice) {
                            $variantWholeSalePrices[] = $this->wholesalePriceTransformer->transform($wholesalePrice);
                        }
                    }

                    $productVariantLogicDto->setWholesalePrices($variantWholeSalePrices);
                }
            }
        }

        return $response;
    }
}
