<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\ProductVariants\Module\CDev\Sale\Transformer\XLite\Model\Product\Logic\Entity\Storefront;

use XCart\Transformer\XLite\Model\Product\Logic\Entity\Storefront\ProductInterface;
use XLite\Model\Product as Source;
use XCart\Logic\Entity\Storefront\Product as Target;

class ProductDecorator implements ProductInterface
{
    public function __construct(
        private ProductInterface $inner
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->inner->transform($input);

        /** @var \XC\ProductVariants\Model\ProductVariant|null $defaultVariant */
        if (
            ($defaultVariant = $input->getDefaultVariant())
            && !$defaultVariant->getDefaultSale()
        ) {
            $target->setDiscountType($defaultVariant->getDiscountType());

            $defaultVariantSalePriceValue = $defaultVariant->getSalePriceValue();
            if ($defaultVariantSalePriceValue) {
                $target->setParticipateSale(true);
                $target->setSaleValue($defaultVariantSalePriceValue);
                $target->setSalePrice($defaultVariant->getDisplayPrice());
            } else {
                $target->setParticipateSale(false);
                $target->setSaleValue(0);
                $target->setSalePrice($target->getPrice());
            }
        }

        return $target;
    }
}
