<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ProductVariants\Logic\Action\Storefront\CartItem\CreateOne\Assembler;

use XCart\Bundle\DoctrineBridgeBundle\Assembler\CreateOne\Entity\EntityAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\LogicBundle\DTO\Request\PayloadOwnerRequestInterface;
use XCart\Logic\Action\Storefront\Cart\Item\CreateOne\DTO\Request as RequestLogic;
use XLite\Model\OrderItem as CartItemModel;

class EntityAssemblerDecorator implements EntityAssemblerInterface
{
    public function __construct(
        private EntityAssemblerInterface $inner,
    ) {
    }

    /**
     * @param RequestLogic $request
     *
     * @return CartItemModel
     */
    public function assembler(PayloadOwnerRequestInterface $request): EntityInterface
    {
        /** @var CartItemModel $entity */
        $entity  = $this->inner->assembler($request);
        $product = $entity->getProduct();

        if ($product->mustHaveVariants()) {
            $variant = $product->getVariantByAttributeValuesIds(
                $entity->getAttributeValuesIds()
            );

            $entity->setVariant($variant);
        }

        return $entity;
    }
}
