<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\ProductVariants\LifetimeHook;

use XLite\Model\QuickData;

final class Install
{
    public function onInstall(): void
    {
        $queryBuilder = \XLite\Core\Database::getEM()->createQueryBuilder();
        $queryBuilder->update(QuickData::class, 'qd')
            ->set('qd.minPrice', 'qd.price')
            ->set('qd.maxPrice', 'qd.price')
            ->getQuery()
            ->execute();
    }
}
