<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ProductVariants\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XC\ProductVariants\Model\ProductVariant;

final class ProductVariantCallback
{
    public function prePersist(ProductVariant $productVariant, LifecycleEventArgs $args): void
    {
        /** @var \XC\ProductVariants\Model\Repo\ProductVariant $repo */
        $repo = $args->getObjectManager()->getRepository(get_class($productVariant));
        if (!$productVariant->getVariantId()) {
            $productVariant->setVariantId($repo->assembleUniqueVariantId($productVariant));
        }
    }

    public function postUpdate(ProductVariant $productVariant, LifecycleEventArgs $args): void
    {
        if ($productVariant->isLowLimitReached() && $productVariant->isShouldSend()) {
            $productVariant->sendLowLimitNotification();
        }
    }
}
