<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ProductVariants\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use XC\ProductVariants\Module\XC\SystemFields\Transformer\XC\ProductVariants\Model\ProductVariant\Logic\Entity\Storefront\ProductVariantDecorator as ProductVariantTransformerDecorator;
use XC\ProductVariants\Transformer\XC\ProductVariants\Model\ProductVariant\Logic\Entity\Storefront\ProductVariant as ProductVariantTransformer;

class RegisterProductVariantTransformerDecoratorBySystemFieldsBundlePass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $productVariantTransformerDecoratorDefinition = (new Definition(ProductVariantTransformerDecorator::class))
            ->setDecoratedService(ProductVariantTransformer::class, null, -10)
            ->setPublic(true)
            ->setAutowired(true);

        $container->setDefinition(
            'ProductVariants_SystemFields_Bundles_ProductVariantTransformerDecorator',
            $productVariantTransformerDecoratorDefinition
        );
    }
}
