<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ProductVariants\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use XC\ProductVariants\Module\QSL\CallForPrice\Transformer\XLite\Model\Product\Logic\Entity\Storefront\ProductDecorator as ProductTransformerDecorator;
use XCart\Transformer\XLite\Model\Product\Logic\Entity\Storefront\Product as ProductTransformer;

class RegisterProductTransformerDecoratorByCallForPriceBundlePass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $productTransformerDecoratorDefinition = (new Definition(ProductTransformerDecorator::class))
            ->setDecoratedService(ProductTransformer::class, null, -10)
            ->setPublic(true)
            ->setAutowired(true);

        $container->setDefinition(
            'ProductVariants_CallForPrice_Bundles_ProductVariantTransformerDecorator',
            $productTransformerDecoratorDefinition
        );
    }
}
