<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ProductVariants\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Reference;
use XC\ProductVariants\Module\CDev\Wholesale\Logic\Action\Storefront\Product\GetOne\ActionDecorator as ProductGetOneActionDecorator;

class RegisterProductGetOneActionDecoratorByWholesaleBundlePass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $productGetOneByIdActionDecoratorDefinition = (new Definition(ProductGetOneActionDecorator::class))
            ->setDecoratedService('xcart.logic.storefront.product.get_one_by_id.action', null, 30)
            ->setPublic(true)
            ->setAutowired(true)
            ->setArgument('$queryBuilderAssembler', new Reference('xcart.logic.storefront.product.get_one_by_id.assembler.query_builder'))
            ->setArgument('$variantDataSource', new Reference('xcart.data_source.product_variant.read'));

        $container->setDefinition(
            'xcart.logic.storefront.product.get_one_by_id.action.decorator.product_variants.wholesale_prices',
            $productGetOneByIdActionDecoratorDefinition
        );

        $productGetOneByCleanUrlActionDecoratorDefinition = (new Definition(ProductGetOneActionDecorator::class))
            ->setDecoratedService('xcart.logic.storefront.product.get_one_by_clean_url.action', null, 30)
            ->setPublic(true)
            ->setAutowired(true)
            ->setArgument('$queryBuilderAssembler', new Reference('xcart.logic.storefront.product.get_one_by_clean_url.assembler.query_builder'))
            ->setArgument('$variantDataSource', new Reference('xcart.data_source.product_variant.read'));

        $container->setDefinition(
            'xcart.logic.storefront.product.get_one_by_clean_url.action.decorator.product_variants.wholesale_prices',
            $productGetOneByCleanUrlActionDecoratorDefinition
        );
    }
}
