<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ProductVariants\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class AddWholesaleFieldsForProductVariantPass implements CompilerPassInterface
{
    use AddFieldsForProductVariantTrait;

    public function process(ContainerBuilder $container): void
    {
        $this->addProductVariantFields(
            $container,
            $this->getAdditionalFields()
        );
    }

    private function getAdditionalFields(): array
    {
        return [
            'wholesalePrices' => [
                'annotations' => [],
                'groups'      => [],
                'nullable'    => true,
                'type'        => 'XCart\API\Entity\Storefront\WholesalePrice[]',
            ],
        ];
    }
}
