<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ProductVariants\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use XCart\API\Entity\Storefront\ProductVariant as ApiProductVariant;
use XCart\Logic\Entity\Storefront\ProductVariant as LogicProductVariant;

trait AddFieldsForProductVariantTrait
{
    private function addProductVariantFields(
        ContainerBuilder $container,
        array $fields
    ): void {
        $dtoGeneratorConfigName = 'xcart.dto_generator.config';

        if ($container->getParameter($dtoGeneratorConfigName)) {
            /** @var array[] $dtoGeneratorConfig */
            $dtoGeneratorConfig = $container->getParameter($dtoGeneratorConfigName);

            $dtoGeneratorConfig['entities']['dto'][ApiProductVariant::class]['fields'] = array_merge(
                $dtoGeneratorConfig['entities']['dto'][ApiProductVariant::class]['fields'],
                $fields
            );

            $logicFields = array_map(
                static function ($field) {
                    $field['type'] = str_replace(
                        'XCart\API\Entity',
                        'XCart\Logic\Entity',
                        $field['type']
                    );

                    return $field;
                },
                $fields
            );

            $dtoGeneratorConfig['entities']['dto'][LogicProductVariant::class]['fields'] = array_merge(
                $dtoGeneratorConfig['entities']['dto'][LogicProductVariant::class]['fields'],
                $logicFields
            );

            $container->setParameter($dtoGeneratorConfigName, $dtoGeneratorConfig);
        }
    }
}
