/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Product details controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

/**
 * Controller
 */

jQuery(document).ready(
  function () {
    const $productDetails = jQuery('div.product-details');
    const use = $productDetails.data('use-widgets-collection');
    const form = jQuery("ul.attribute-values").parent('div').prev('form');
    const productId = jQuery('input[name="product_id"]', form).val();
    let params;

    xcart.bind(
      'update-product-page',
      function (event, productId) {
        if ($productDetails.length > 0 && typeof($productDetails.get(0).controller) !== 'undefined') {
          $productDetails.get(0).controller.block.loadVariantsImages(productId);
          params = xcart.getWidgetsParams('update-product-page', {product_id: productId});
        }
      }
    );

    if (typeof(use) !== 'undefined' && !use) {
      xcart.bind(
        'update-variant-image',
        function (event, productId) {
          $productDetails.get(0).controller.block.loadVariantsImages(productId, true);
        }
      );

      const handler = function () {
        xcart.trigger('update-variant-image', productId);
      };

      jQuery("ul.attribute-values input[type='checkbox']").unbind('change').change(handler);
      jQuery("ul.attribute-values input.blocks-input").unbind('change').change(handler);
      jQuery("ul.attribute-values select").unbind('change').change(handler);
    }

    if ($productDetails.length > 0 && typeof($productDetails.get(0).controller) !== 'undefined') {
      $productDetails.get(0).controller.block.loadVariantsImages(productId);
    }

    xcart.bind(
      'product.details.quantityBox.initialize',
      function () {
        if ($productDetails.length > 0 && typeof($productDetails.get(0).controller) !== 'undefined') {
          const updatedAttributes = [];
          const attributeSelectors = jQuery('ul.attribute-values [data-attribute-id]');

          attributeSelectors.each(function () {
            const $this = jQuery(this);

            if ($this.attr('type') !== 'checkbox' || $this.attr('type') === 'checkbox' && $this.is(':checked')) {
              updatedAttributes.push($this.data('attribute-id') + '_' + $this.val());
            } else if ($this.attr('type') === 'checkbox' && !$this.is(':checked')) {
              updatedAttributes.push($this.data('attribute-id') + '_' + $this.data('unchecked'));
            }
          });

          const difference = _.difference(params.attribute_values.split(',').filter(i => i !== ''), updatedAttributes);

          const handler = function (productId) {
            xcart.trigger('update-product-page', productId);
          };

          if (difference.length) {
            attributeSelectors.trigger('change', function () {
              handler(productId);
            });
          }
        }
      }
    );
  }
);

ProductDetailsView.prototype.fakeLoupeLink = null;

// Load variant image
ProductDetailsView.prototype.loadVariantsImages = function (productId, shade) {
  if (this.base.data('variants-has-images')) {

    if (shade) {
      this.base.find('.product-details-info').append('<div class="single-progress-mark"><div></div></div>');
    }

    this.loadVariantsImagesShade = shade;

    // Request variant images info
    xcart.get(
      URLHandler.buildURL(this.getURLParametersForLoadVariantsImages(productId)),
      _.bind(this.handleLoadVariantsImages, this),
      null,
      {dataType: 'json'}
    );
  }
};

// Get URL parameters for variant image loading routine
ProductDetailsView.prototype.getURLParametersForLoadVariantsImages = function (productId) {
  var params = {product_id: productId};
  params = array_merge(params, xcart.getWidgetsParams('update-product-page', params));

  return array_merge({'target': 'product', 'action': 'get_variant_images'}, params);
};

// Load variant image handler
ProductDetailsView.prototype.handleLoadVariantsImages = function (XMLHttpRequest, textStatus, data) {
  if (data && _.isString(data)) {
    data = jQuery.parseJSON(data);
  }

  if (this.base.find('.product-image-gallery:visible').length > 0) {
    this.processVariantImageAsGallery(data);

  } else {
    this.processVariantImageAsImage(data);
  }

  if (this.loadVariantsImagesShade) {
    this.base.find('.product-details-info .single-progress-mark').remove();
  }
};

ProductDetailsView.prototype.processVariantImageAsGallery = function (data) {
  const self = this;

  let imageChanged = false;

  const galleries = this.base.find('.product-image-gallery');

  galleries.each(function () {
    const $gallery = jQuery(this);

    if (data && _.isObject(data)) {

      imageChanged = imageChanged || $gallery.find('li.variant-image a').attr('href') !== data.full.url;

      if (imageChanged) {

        // Remove old variant image
        const li = $gallery.find('li').eq(0).clone(true);

        $gallery.find('li.variant-image').remove();

        // Change images
        let elm = li.find('a img');
        elm.attr('width', data.gallery.w)
          .attr('height', data.gallery.h)
          .attr('src', data.gallery.url)
          .attr('srcset', data.gallery.srcset)
          .attr('alt', data.gallery.alt)
          .css({
            width: data.gallery.w + 'px',
            height: data.gallery.h + 'px'
          });

        elm = li.find('img.middle');
        elm.attr('width', data.main.w)
          .attr('height', data.main.h)
          .attr('src', data.main.url)
          .attr('srcset', data.main.srcset)
          .attr('alt', data.main.alt)
          .css({
            width: data.main.w + 'px',
            height: data.main.h + 'px'
          });

        // Change gallery link
        li.find('a')
          .attr('href', data.full.url)
          .attr('rev', 'width: ' + data.full.w + ', height: ' + data.full.h);

        li.addClass('variant-image');

        $gallery.find('li').eq(0).before(li);

        // Gallery icon vertical aligment
        const margin = (li.height() - li.find('a img').height()) / 2;

        li.find('a img').css({
          'margin-top': Math.ceil(margin) + 'px',
          'margin-bottom': Math.floor(margin) + 'px'
        });
      }

    } else if ($gallery.find('li.variant-image').length > 0) {

      imageChanged = true;

      // Remove old variant image
      $gallery.find('li.variant-image').remove();

    }
  });
  if (imageChanged) {
    self.initializeGallery();
    self.hideLightbox();

    self.applyToGalleries(function (gallery) {
      if (gallery.get(0)) {
        $(gallery.get(0)).find('a').click();
      }
    });
  }
};

ProductDetailsView.prototype.processVariantImageAsImage = function (data) {
  if (!this.fakeLoupeLink) {
    this.fakeLoupeLink = this.base.find('.default-image');
    this.fakeLoupeLink.colorbox(this.getColorboxOptions());
    this.base.find('.loupe')
      .unbind('click')
      .click(
        _.bind(
          function () {
            this.fakeLoupeLink.click();
          },
          this
        )
      );
  }

  if (data && _.isObject(data)) {
    const elm = this.base.find('img.product-thumbnail');
    elm.attr('width', data.main.w)
      .attr('height', data.main.h)
      .attr('src', data.main.url)
      .attr('srcset', data.main.srcset)
      .attr('alt', data.main.alt)
      .css({
        width: data.main.w + 'px',
        height: data.main.h + 'px'
      });

    this.fakeLoupeLink.attr('href', data.full.url);
    this.base.find('.loupe').show();

    this.base.find('a.cloud-zoom').attr('href', data.full.url);
    this.base.find('.cloud-zoom').trigger('cloud-zoom');

  } else {
    this.applyDefaultImage();
  }

};

ProductDetailsView.prototype.applyDefaultImage = function () {
  if (this.base.find('.product-image-gallery li').length > 0) {
    const a = this.base.find('.product-image-gallery li a');
    const img = this.base.find('.product-image-gallery li img.middle');
    const elm = this.base.find('img.product-thumbnail');
    elm.attr('src', img.attr('src'))
      .attr('srcset', img.attr('srcset') || null)
      .attr('width', img.attr('width'))
      .attr('height', img.attr('height'))
      .css({
        'width': img.attr('width') + 'px',
        'height': img.attr('height') + 'px'
      });

    this.fakeLoupeLink.attr('href', a.attr('href'));
    this.base.find('.loupe').show();

    this.base.find('a.cloud-zoom').attr('href', a.attr('href'));
    this.base.find('.cloud-zoom').trigger('cloud-zoom');

  } else {
    const img = this.base.find('.default-image img');
    const elm = this.base.find('img.product-thumbnail');

    elm.attr('src', img.attr('src'))
      .attr('srcset', img.attr('srcset') || null)
      .attr('width', img.attr('width'))
      .attr('height', img.attr('height'))
      .css({
        'width': img.attr('width') + 'px',
        'height': img.attr('height') + 'px'
      });

    this.base.find('a.cloud-zoom').attr('href', img.attr('src'));

    this.base.find('.loupe').hide();

    const zoom = this.base.find('a.cloud-zoom').data('zoom');
    if (zoom) {
      zoom.destroy();
    }
    this.base.find('a.cloud-zoom')
      .unbind('click')
      .click(function () {
        return false;
      });
  }
};
