<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\ProductTags\Transformer\XLite\Model\Product\Logic\Entity\Storefront;

use XCart\Transformer\XLite\Model\Product\Logic\Entity\Storefront\ProductInterface;
use XLite\Model\Product as Source;
use XCart\Logic\Entity\Storefront\Product as Target;

class ProductDecorator implements ProductInterface
{
    public function __construct(
        private ProductInterface $inner
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->inner->transform($input);

        $target->setTags($this->getTransformedTags($input));

        return $target;
    }

    /**
     * @return string[]
     */
    private function getTransformedTags(Source $input): array
    {
        $transformedTags = [];

        /* @var \XC\ProductTags\Model\Tag $tag */
        foreach ($input->getTags() as $tag) {
            $transformedTags[] = $tag->getName();
        }

        return $transformedTags;
    }
}
