<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ProductTags\Operation\Service\DataSource\Product\Applier\SubstringApplier;

use XCart\Operation\Service\DataSource\Product\Applier\SubstringApplier\GetSubstringSearchFieldsInterface;

class GetSubstringSearchFieldsDecorator implements GetSubstringSearchFieldsInterface
{
    public function __construct(
        private GetSubstringSearchFieldsInterface $inner
    ) {
    }

    public function __invoke(): array
    {
        return array_merge(
            $this->inner->__invoke(),
            ['tagsTranslations.name']
        );
    }
}
