<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ProductTags\Logic\Import\Processor;

use XC\ProductTags\Model\Tag;
use XCart\Extender\Mapping\Extender;

/**
 * Products
 * @Extender\Mixin
 */
abstract class Products extends \XLite\Logic\Import\Processor\Products
{
    /**
     * Define columns
     *
     * @return array
     */
    protected function defineColumns()
    {
        $columns = parent::defineColumns();

        $columns['tags'] = [
            static::COLUMN_IS_MULTIPLE     => true
        ];

        return $columns;
    }

    /**
     * Verify 'tags' value
     *
     * @param mixed $value  Value
     * @param array $column Column info
     *
     * @return void
     */
    protected function verifyTags($value, array $column)
    {
    }

    protected function preImportTags($value, array $data)
    {
        if ($value && !$this->verifyValueAsNull($value)) {
            $tagIds = [];
            foreach ($value as $tagName) {
                if ($tagName) {
                    /** @var Tag|null $tag */
                    $tag = $this->insertIfNotExists($tagName, Tag::class);

                    if ($tag) {
                        $tagIds[] = [$tag, 'getId'];
                    }
                }
            }

            $this->currentRowData['tags'] = static fn () => array_map(static fn ($callable) => $callable(), $tagIds);
        }
    }

    /**
     * Import 'marketPrice' value
     *
     * @param \XLite\Model\Product $model  Product
     * @param string               $value  Value
     * @param array                $column Column info
     *
     * @return void
     */
    protected function importTagsColumn(\XLite\Model\Product $model, array $value, array $column)
    {
        if ($tags = $model->getTags()) {
            foreach ($tags as $k => $tag) {
                $tags->remove($k);
            }
        }

        if (!$this->verifyValueAsNull($value)) {
            foreach ($value as $tagNameOrId) {
                if ($tagNameOrId) {
                    if (!is_int($tagNameOrId)) {
                        $tag = \XLite\Core\Database::getRepo(Tag::class)?->createTagByName($tagNameOrId);
                    } else {
                        $tag = \XLite\Core\Database::getRepo(Tag::class)?->find($tagNameOrId);
                    }

                    if ($tag) {
                        $model->addTag($tag);
                        $tag->addProduct($model, true);
                    }
                }
            }
        }
    }

    public function clearEntitiesCaches(): void
    {
        parent::clearEntitiesCaches();

        \XLite\Core\Database::getRepo('XC\ProductTags\Model\Tag')?->clearInsertedCache();
    }
}
