<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ProductTags\Controller\Admin;

use XC\ProductTags\Model\Tag;
use XLite\Core\Database;

class SearchTags extends \XLite\Controller\Admin\AAdmin
{
    public const DEFAULT_COUNT_PER_PAGE = 20;

    protected function doNoAction()
    {
        $getParams = \XLite\Core\Request::getInstance()->getGetData();
        $search = $getParams['search'] ?? '';
        $page = $getParams['page'] ?? 1;
        $countPerPage = $getParams['countPerPage'] ?? static::DEFAULT_COUNT_PER_PAGE;

        $result = [];
        $tags = Database::getRepo(Tag::class)?->findAllBySearchParams($page, $countPerPage, $search);

        $result['tags'] = array_map(
            static fn (Tag $tag): array => ['id' => $tag->getId(), 'text' => $tag->getName()],
            (array) $tags->getIterator()
        );

        $result['more'] = $tags->count() > $page * $countPerPage;

        $this->printAJAX($result);
    }

    /**
     * Check ACL permissions
     *
     * @return boolean
     */
    public function checkACL()
    {
        return true;
    }
}
