/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

(function () {

  Vue.directive('xliteTags', {
    inserted: function (el, binding) {
      var $el = $(el);
      var model = binding.expression.split('.');
      var prop = model.pop();
      var vm = Vue.getClosestVueInstance(el);

      if (!vm) {
        return;
      }

      var target = _.get(vm, model);

      var searchingLbl = el.getAttribute('searching-lbl')
        , noResultsLbl = el.getAttribute('no-results-lbl')
        , allowCreateTags = el.getAttribute('allow-create-tags');

      $el
        .select2(
          {
            language: {
              noResults: function () {
                return noResultsLbl;
              },
              searching: function () {
                return searchingLbl;
              }
            },
            tags: allowCreateTags,
            escapeMarkup: function (markup) {
              return markup;
            },
            createTag: function (params) {
              return {
                id: '_' + params.term,
                text: params.term,
                newTag: true // add additional parameters
              }
            },
            ajax: {
              url: xliteConfig.script + "?target=search_tags",
              delay: 250,
              dataType: 'json',
              data: function (params) {
                return {
                  search: params.term,
                  page: params.page || 1
                };
              },
              processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                  results: data.tags,
                  pagination: {
                    more: data.more
                  }
                };
              },
            },
            templateResult: function (tag, selectItem) {
              if (tag.loading) {
                return '<span class="searching">' + 'searching' + '</span>';
              }

              return '<span class="text">' + tag.text + '</span>';
            },
          }
        )
        .on('select2:select', function () {
          target[prop] = $el.val() || [];
        })
        .on('select2:unselect', function () {
          target[prop] = $el.val() || [];
        });
    }
  });
})();
