/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Float field microcontroller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */


define('modules/XC/FroalaEditor/colorPalette',
  ['js/vue/vue', 'colorpicker/pickr'],
  function (XLiteVue, ColorPicker) {

    XLiteVue.component('color-palette-picker', {

      replace: false,

      data: function () {
        return {
          colors: []
        }
      },

      ready: function () {
        const self = this
        const addButton = jQuery(this.$el).find('.new-color')
        CommonForm.autoassign(jQuery(this.$el))
        this.initColorPicker(addButton)
        xcart.bind('color-picker.save', function () {
          self.addColor()
        })
      },

      computed: {
        colorPalette: function () {
          const colors = _.map(
            this.colors,
            function (color) {
              return color.value
            }
          )
          return colors.join(',')
        }
      },

      watch: {
        colorPalette: function (value, oldValue) {
          jQuery(this.$el).find(':input').change()
        }
      },

      methods: {
        addColor: function () {
          const color = this.colorpicker.selectedColor()

          if (color) {
            this.colors.push({value: color})
          }
        },

        removeColor: function (index) {
          this.colors.splice(index, 1)
        },

        initColorPicker: function (element) {
          const self = this

          self.colorpicker = new ColorPicker(element, {
            useAsButton: true,
            components: {
              preview: true,
              hue: true,
              interaction: {
                input: true,
                save: true
              }
            }
          })

          self.colorpicker.$el.on('click', function () {
            self.colorpicker.show()
          })
        }
      }
    })
  })
