/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Color selector
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function ColorSelector(base)
{
  base = jQuery(base);
  if (0 < base.length && base.hasClass('color-selector-box') && !base.get(0).controller) {
    base.get(0).controller = this;
    this.base = base;
    this.init();
  }
}

extend(ColorSelector, Base);

// Autoloader
ColorSelector.autoload = function()
{
  jQuery('.color-selector-box').each(
      function() {
        new ColorSelector(this);
      }
    );
};

ColorSelector.prototype.view = null;
ColorSelector.prototype.selector = null;
ColorSelector.prototype.input = null;

ColorSelector.prototype.init = function()
{
  this.view = this.base.find('.view').eq(0);
  this.view.bind(
    'click',
    _.bind(this.showSelector, this)
  );

  this.selector = this.base.find('.color-selector').eq(0);

  $('.color-box', this.selector).bind(
    'click',
    _.bind(this.selectColor, this)
  );

  this.input = this.base.find('input[type=text]').eq(0);
}

ColorSelector.prototype.hideSelector = function()
{
  $('.color-selector').hide();

  jQuery(document).unbind(
    'click',
    _.bind(this.hideSelector, this)
  );

  jQuery(document).unbind('keyup');
}

ColorSelector.prototype.showSelector = function()
{
  this.hideSelector();

  var curColor = this.input.val();
  $('.color-box', this.selector).each(function () {
    var color = $(this).attr('data-color');
    if (color && curColor && curColor.toUpperCase() == color.toUpperCase()) {
      if (!$(this).hasClass('remove')) {
        $(this).addClass('selected');
      }
    } else {
      $(this).removeClass('selected');
    }
  });

  var left = ((this.selector.width() / 2) - parseInt(this.view.outerWidth(true) / 2)) * -1;
  this.selector.css('left', left);
  this.selector.show();

  jQuery(document).bind(
    'click',
    _.bind(this.hideSelector, this)
  );

  var obj = this;
  jQuery(document).keyup(function(e) {
    if (e.which == 27) {
      obj.hideSelector();
    }
  });

  return false;
}

ColorSelector.prototype.selectColor = function(event)
{
  var color = $(event.target).attr('data-color');

  if (color) {
    this.input.val(color.toUpperCase());
    this.view.css('background-color', '#' + color.toUpperCase());
  } else {
    this.input.val('');
    this.view.css('background-color', '');
  }
  this.input.change(); // to enabled submit button
  this.hideSelector();

  return false;
}

xcart.autoload(ColorSelector);
