<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\View\WizardStep;

/**
 * ShippingRates
 */
class ShippingRates extends \XC\Onboarding\View\AWizardStep
{
    /**
     * @return string
     */
    protected function getMoreSettingsLocation()
    {
        return $this->buildURL('shipping_methods');
    }

    /**
     * @return string
     */
    protected function getArticleLink()
    {
        return static::t('https://support.x-cart.com/en/articles/4425828-custom-table-rates');
    }

    /**
     * @return mixed
     */
    protected function getMethodsData()
    {
        return array_reduce($this->getMethods(), static function ($data, $method) {
            /** @var \XLite\Model\Shipping\Method $method */
            $data[$method->getProcessor()] = [
                'method_id' => $method->getMethodId(),
                'processor' => $method->getProcessor(),
                'is_added'  => $method->isAdded(),
                'name'      => $method->getName(),
            ];

            return $data;
        });
    }

    /**
     * Returns online shipping methods (carriers)
     *
     * @return \XLite\Model\Shipping\Method[]
     */
    protected function getMethods()
    {
        return [];
        //$repo = \XLite\Core\Database::getRepo('XLite\Model\Shipping\Method');

        //return array_filter($repo->findOnlineCarriers(), function (\XLite\Model\Shipping\Method $method) {
        //    return $method->getAdminIconURL()
        //        && (
        //            !$method->getProcessorModule()
        //            || $method->getProcessorModule()->getEnabled()
        //        );
        //});
    }

    /**
     * @return string
     */
    protected function getDefaultMethodName()
    {
        return static::t('My shipping');
    }

    /**
     * Returns shipping carrier settings url
     *
     * @param \XLite\Model\Shipping\Method $method Shipping method
     *
     * @return string
     */
    protected function getSettingsURL(\XLite\Model\Shipping\Method $method)
    {
        return null;
    }
}
