<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\View\WizardStep;

/**
 * Payment
 */
class Payment extends \XC\Onboarding\View\AWizardStep
{
    /**
     * @return string
     */
    protected function getMoreSettingsLocation()
    {
        return $this->buildURL('payment_settings', '', [
            'show_add_payment_popup' => 1,
        ]);
    }

    /**
     * @return array
     */
    protected function getOnlineWidgets()
    {
        return [];
    }

    /**
     * @return array
     */
    protected function getOnlineWidgetsSorted()
    {
        $widgets = $this->getOnlineWidgets();

        ksort($widgets);

        return $widgets;
    }
}
