<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\View\WizardStep;

/**
 * Done
 */
class Done extends \XC\Onboarding\View\AWizardStep
{
    /**
     * @return string
     */
    protected function getPhoneNumber()
    {
        return '1-800-657-7957';
    }

    /**
     * @return string
     */
    protected function getSalesEmail()
    {
        return 'sales@x-cart.com';
    }

    /**
     * @return string
     */
    protected function getSupportUrl()
    {
        return \XLite::getXCartURL('https://www.x-cart.com/contact-us.html');
    }

    /**
     * @return string
     */
    protected function getKBUrl()
    {
        return 'https://support.x-cart.com/en/';
    }

    /**
     * @return string
     */
    protected function getDevDocsUrl()
    {
        return 'https://developer.x-cart.com/';
    }

    protected function getStorefrontUrl()
    {
        return \XLite::getController()->getShopURL();
    }
}
