<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\View\WizardStep;

use XC\Onboarding\View\AWizardStep;

class BusinessInfo extends AWizardStep
{
    /**
     * @return string
     */
    protected function getCompanyName()
    {
        return \XLite\Core\Config::getInstance()->Company->company_name;
    }

    /**
     * @return string
     */
    protected function getPhone()
    {
        return \XLite\Core\Config::getInstance()->Company->company_phone;
    }

    /**
     * @return string
     */
    protected function getSellExperience()
    {
        return \XLite\Core\Config::getInstance()->Company->sell_experience;
    }

    /**
     * @return string
     */
    protected function getBusinessCategory()
    {
        return \XLite\Core\Config::getInstance()->Company->business_category;
    }

    /**
     * @return string
     */
    protected function getBusinessRevenue()
    {
        return \XLite\Core\Config::getInstance()->Company->business_revenue;
    }
}
