<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\View;

use XCart\Extender\Mapping\Extender;
use XC\Onboarding\Controller\Admin\OnboardingWizard;

/**
 * 'Powered by' widget
 *
 * @Extender\Mixin
 */
class PoweredByAdmin extends \XLite\View\PoweredByAdmin
{
    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'powered_by.twig';
    }

    protected function isVisible()
    {
        return parent::isVisible()
            && ! (\XLite::getController() instanceof OnboardingWizard);
    }
}
