<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\View\FormModel\Product;

use XCart\Extender\Mapping\Extender;

/**
 * Product form model
 * @Extender\Mixin
 */
class Info extends \XLite\View\FormModel\Product\Info
{
    /**
     * @return array
     */
    public function getJSFiles()
    {
        $files = parent::getJSFiles();

        if (isset(\XLite\Core\Request::getInstance()->prefill['name']) && \XLite\Core\Request::getInstance()->prefill['name']) {
            $files[] = 'modules/XC/Onboarding/form_model/product/info.js';
        }

        return $files;
    }

    /**
     * @return array
     */
    protected function defineFields()
    {
        $schema = parent::defineFields();
        $files = $schema[self::SECTION_DEFAULT]['images']['files'] ?? null;

        if ($files !== null && !$this->getDataObject()->default->identity && isset(\XLite\Core\Request::getInstance()->prefill['image'])) {
            $image = \XLite\Core\Request::getInstance()->prefill['image'];

            /** @var \XC\Onboarding\Model\TemporaryFile $file */
            $file = $image['temp_id']
                ? \XLite\Core\Database::getRepo('XLite\Model\TemporaryFile')->find($image['temp_id'])
                : null;

            if ($file) {
                $file->setAlt($image['alt']);
                $schema[self::SECTION_DEFAULT]['images']['files'][-1] = $file;
            }
        }

        return $schema;
    }
}
