<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\View;

use XCart\Extender\Mapping\Extender;
use XC\Onboarding\Controller\Admin\OnboardingWizard;

/**
 * File uploader
 * @Extender\Mixin
 */
class FileUploader extends \XLite\View\FileUploader
{
    /**
     * Get a list of JS files required to display the widget properly
     *
     * @return array
     */
    public function getJSFiles()
    {
        $list = parent::getJSFiles();

        if (\XLite::getController() instanceof OnboardingWizard) {
            $list[] = 'modules/XC/Onboarding/file_uploader/onboarding.js';
        }

        return $list;
    }
}
