<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\View\Dashboard;

use XCart\Extender\Mapping\ListChild;

/**
 * Wizard mini informer on Dashboard
 *
 * @ListChild(list="dashboard-sidebar", weight="50", zone="admin")
 */
class WizardStatus extends \XC\Onboarding\View\MiniWizardStatus
{
    /**
     * Add widget specific CSS file
     *
     * @return array
     */
    public function getCSSFiles()
    {
        $list = parent::getCSSFiles();
        $list[] = 'modules/XC/Onboarding/dashboard/wizard/style.less';

        return $list;
    }

    /**
     * @return string
     */
    protected function isTargetIsAllowed()
    {
        return \XLite::getController()->getTarget() === 'main';
    }
}
