<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\View\Button;

class BrowseTools extends \XLite\View\Button\SimpleLink
{
    public function __construct(array $params = [])
    {
        parent::__construct(array_merge([
            \XLite\View\Button\AButton::PARAM_LABEL   => 'Browse Top Trending Tools',
            \XLite\View\Button\AButton::PARAM_STYLE   => 'always-enabled external marketplace-link',
            \XLite\View\Button\Link::PARAM_LOCATION   => $this->getBrowseToolsUrl(),
            \XLite\View\Button\Link::PARAM_BLANK      => true,
            \XLite\View\Button\Link::PARAM_ATTRIBUTES => [
                'v-on:click' => 'browseTools()',
            ],
        ], $params));
    }

    protected function getBrowseToolsUrl(): string
    {
        return \XLite::getInstance()->getAppStoreUrl() . 'addons/';
    }
}
