<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\Module\XPay\XPaymentsCloud;

use XCart\Extender\Mapping\Extender;

/**
 * Payment step
 *
 * @Extender\Mixin
 * @Extender\Depend("XPay\XPaymentsCloud")
 */
class Payment extends \XC\Onboarding\View\WizardStep\Payment
{
    public const XPAYMENT_SORT = 20;

    /**
     * @return array
     */
    protected function getOnlineWidgets()
    {
        $widgets = parent::getOnlineWidgets();
        $widgets[self::XPAYMENT_SORT] = View\Onboarding\Payment::class;

        return $widgets;
    }
}
