<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\Model\Repo;

use XCart\Extender\Mapping\Extender;

/**
 * The "product" model repository
 * @Extender\Mixin
 */
class Order extends \XLite\Model\Repo\Order
{
    public function getDemoEntitiesCount()
    {
        return $this->createPureQueryBuilder('o')
            ->select('COUNT(o)')
            ->andWhere('o.demo = 1')
            ->getSingleScalarResult();
    }

    public function deleteDemoEntities()
    {
        $orders = $this->findBy(['demo' => 1]);
        foreach ($orders as $order) {
            $this->delete($order, true);
        }
    }
}
