<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\Model\Repo\Image\Common;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Request;
use XC\Onboarding\Core\WizardState;
use Includes\Utils\FileManager;
use XC\Onboarding\View\WizardStep\CompanyLogoAdded;

/**
 * @Extender\Mixin
 */
class Logo extends \XLite\Model\Repo\Image\Common\Logo
{
    /**
     * @return \XLite\Model\Image\Common\Logo
     */
    public function getLogo()
    {
        $cookieLogoURL = Request::getInstance()->{WizardState::COOKIE_LASTLOGO};
        if ($cookieLogoURL && strpos($cookieLogoURL, '//') === 0) {
            $cookieLogoURL = str_replace('//', 'http://', $cookieLogoURL);
        }

        if (Request::getInstance()->{CompanyLogoAdded::CHECK_NEW_LOGO} && $cookieLogoURL) {
            $cookieLogo = new \XLite\Model\Image\Content();
            $cookieLogo->loadFromURL($cookieLogoURL, true);
            $cookieLogoRelativePath = FileManager::getRelativePath(
                $cookieLogo->getStoragePath(),
                LC_DIR_ROOT
            );

            return self::getFakeImageObject($cookieLogoRelativePath);
        }

        return parent::getLogo();
    }
}
