<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\Model\DTO\Product;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Request;
use XLite\Core\Converter;
use XLite\Core\Operator;
use XC\Onboarding\Core\WizardState;

/**
 * @Extender\Mixin
 */
class Info extends \XLite\Model\DTO\Product\Info
{
    /**
     * @param mixed|\XLite\Model\Product $object
     */
    protected function init($object)
    {
        parent::init($object);

        if (!$this->default->identity && isset(Request::getInstance()->prefill)) {
            if (isset(Request::getInstance()->prefill['name'])) {
                $this->default->name = Request::getInstance()->prefill['name'];
            }

            if (isset(Request::getInstance()->prefill['price'])) {
                $this->prices_and_inventory->price = Request::getInstance()->prefill['price'];
            }
        }
    }

    public function afterCreate($object, $rawData = null)
    {
        parent::afterCreate($object, $rawData);

        if (isset(\XLite\Core\Request::getInstance()->onboarding)) {
            $data = json_decode(\XLite\Core\Request::getInstance()->onboarding, true);

            if (!empty($data['prefilled_form'])) {
                WizardState::getInstance()->setLastAddedProductId($object->getProductId());

                $onboardingUrl = Converter::buildURL('onboarding_wizard');
                Operator::redirect($onboardingUrl);
            }
        }
    }
}
