<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\Controller\Admin;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class ShippingSettings extends \XLite\Controller\Admin\ShippingSettings
{
    protected function doActionSwitch()
    {
        parent::doActionSwitch();

        $this->markAsChangedForOnboarding();
    }

    public function doActionUpdate()
    {
        parent::doActionUpdate();

        $this->markAsChangedForOnboarding();
    }

    protected function markAsChangedForOnboarding()
    {
        \XLite\Core\TmpVars::getInstance()->onboarding_shipping_changed = 1;
    }
}
