<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\Controller\Admin;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
abstract class ShippingMethods extends \XLite\Controller\Admin\ShippingMethods
{
    public function doActionAdd()
    {
        //Parent method does redirect so mark before it's called
        $this->markAsChangedForOnboarding();

        parent::doActionAdd();
    }

    protected function doActionUpdateItemsList()
    {
        parent::doActionUpdateItemsList();

        $this->markAsChangedForOnboarding();
    }

    protected function markAsChangedForOnboarding()
    {
        \XLite\Core\TmpVars::getInstance()->onboarding_shipping_changed = 1;
    }
}
