<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\Controller\Admin;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Auth;
use XLite\Core\Config;
use XLite\Model\Role\Permission;
use XC\Onboarding\Core\WizardState;

/**
 * Main page controller
 * @Extender\Mixin
 */
class Main extends \XLite\Controller\Admin\Main
{
    /**
     * Run controller
     *
     * @return void
     */
    protected function doNoAction()
    {
        if ($this->shouldRedirectToOnboarding()) {
            $this->redirect($this->buildURL('onboarding_wizard'));
        } else {
            parent::doNoAction();
        }
    }

    /**
     * Check if the user should be redirected to onboarding wizard
     */
    protected function shouldRedirectToOnboarding()
    {
        return !$this->isAJAX()
            && Config::getInstance()->XC->Onboarding->wizard_state === 'visible'
            && Auth::getInstance()->isPermissionAllowed(Permission::ROOT_ACCESS)
            && WizardState::getInstance()->getWizardProgress() < 100;
    }
}
