<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Onboarding\Controller\Admin;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Auth;
use XLite\Core\Config;
use XLite\Model\Role\Permission;
use XC\Onboarding\Core\WizardState;

/**
 * Abstract admin-zone controller
 * @Extender\Mixin
 */
abstract class AAdmin extends \XLite\Controller\Admin\AAdmin
{
    public function handleRequest()
    {
        if (
            Config::getInstance()->XC->Onboarding->wizard_state !== 'disabled'
            && Auth::getInstance()->isPermissionAllowed(Permission::ROOT_ACCESS)
            && WizardState::getInstance()->getWizardProgress() >= 100
        ) {
            WizardState::getInstance()->updateConfigOption('wizard_state', 'disabled');
            \XLite\Core\Config::updateInstance();
        }

        parent::handleRequest();
    }
}
