/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Company logo added
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('wizard/steps/company-logo-added', ['js/vue/vue'], function (XLiteVue) {
  XLiteVue.component('xlite-wizard-step-company-logo-added', {
    ready: function () {
      this.$form = $(this.$el).find('.logo-upload-form')
    },

    computed: Vuex.mapGetters([
      'logoUrl',
      'logoParams'
    ]),

    methods: _.extend(
      Vuex.mapActions([
        'updateLogo',
        'updateLogoFormParams'
      ]), {

      save: function () {
        if (!this.logoParams) {
          console.log('Something wrong happened')
          this.$dispatch('wizard.step.requestNext')
          this.$dispatch('wizard.landmark.pass', 'company')
        }

        this.$dispatch('blockBody')

        xcart.post(
          {
            target: 'onboarding_wizard',
            action: 'upload_company_logo'
          },
          null,
          this.logoParams,
          {
            dataType: 'json',
            rpc: true
          })
          .done(_.bind(this.onUploadSuccess, this))
          .fail(_.bind(this.onUploadFail, this))
      },

      onUploadSuccess: function (data) {
        if (data.logo) {
          this.updateLogo(data.logo)
        }
        this.$dispatch('wizard.tracking.event', 'form')
        this.$dispatch('wizard.step.requestNext')
        this.$dispatch('wizard.landmark.pass', 'company')
        this.$dispatch('unblockBody')
      },

      onUploadFail: function () {
        this.$dispatch('unblockBody')
      },

      goToNextStep: function () {
        this.$dispatch('wizard.tracking.event', 'link', '(skipped)')
        this.$dispatch('wizard.step.requestNext')
      },

      reuploadLogo: function () {
        this.$dispatch('wizard.step.requestPrevious')
      },

      openLayoutEditorVideo: function () {
        console.error('not implemented yey')
      },

      visitTemplateStore: function () {
        this.$dispatch('wizard.tracking.event', 'link', 'Visit the template store')
        window.open('service.php#/templates')
      }
    })
  })
})
