<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\News\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XC\News\Model\NewsMessage;

final class ProductCallback
{
    public function prePersist(NewsMessage $newsMessage, LifecycleEventArgs $args): void
    {
        $this->prepareBeforeSave($newsMessage);
    }

    public function preUpdate(NewsMessage $newsMessage, LifecycleEventArgs $args): void
    {
        $this->prepareBeforeSave($newsMessage);
    }

    private function prepareBeforeSave(NewsMessage $model): void
    {
        if (!is_numeric($model->getDate()) || !is_int($model->getDate())) {
            $model->setDate(\XLite\Core\Converter::time());
        }
    }
}
