<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\XDependencies\View;

use XCart\Extender\Mapping\Extender;

/**
 * TODO: Resolve the situation that calls for this workaround by using formatInvoicePrice() in MultiVendor module
 * TODO:   or by providing ability to override these functions without the need to copy the code from MultiVendor
 *
 * Invoice widget
 *
 * @Extender\Mixin
 * @Extender\Depend({"XC\MultiVendor","XC\MultiCurrency"})
 */
class Invoice extends \XLite\View\Invoice
{
    /**
     * Get order formatted subtotal
     *
     * @return string
     */
    protected function getOrderTotal()
    {
        return $this->formatInvoicePrice($this->getOrderTotalForVendor(), $this->getOrder()->getCurrency(), true);
    }

    /**
     * Get order formatted subtotal
     *
     * @return string
     */
    protected function getOrderSubtotal()
    {
        return $this->formatInvoicePrice($this->getOrderSubtotalForVendor(), $this->getOrder()->getCurrency(), true);
    }

    /**
     * Get order total for current vendor
     *
     * @return float
     */
    protected function getOrderTotalForVendor()
    {
        $order = $this->getOrder();
        $result = $order->getTotal();
        $vendor = $this->getVendor();

        if ($vendor) {
            if ($order->isSingle()) {
                $itemsResult = array_reduce(
                    $order->getItems()->toArray(),
                    static function ($carry, $item) use ($vendor) {
                        $ofCurrentVendor = $item->getVendor()
                            && $item->getVendor()->getProfileId() === $vendor->getProfileId();

                        return $carry + ($ofCurrentVendor ? $item->getTotal() : 0);
                    },
                    0
                );

                $surchargesResult = array_reduce(
                    $order->getSurcharges()->toArray(),
                    static function ($carry, $item) use ($vendor) {
                        $ofCurrentVendor = $item->getVendor()
                            && $item->getVendor()->getProfileId() === $vendor->getProfileId();

                        return $carry + ($ofCurrentVendor ? $item->getValue() : 0);
                    },
                    0
                );

                $result = $itemsResult + $surchargesResult;
            } elseif (!$order->getVendor() || $order->getVendor()->getProfileId() !== $vendor->getProfileId()) {
                $result = $order->getChildByVendor($vendor)->getTotal();
            }
        }

        return $result;
    }

    /**
     * Get order subtotal for current vendor
     *
     * @return float
     */
    protected function getOrderSubtotalForVendor()
    {
        $order = $this->getOrder();
        $result = $order->getSubtotal();
        $vendor = $this->getVendor();

        if ($vendor) {
            if ($order->isSingle()) {
                $result = array_reduce($order->getItems()->toArray(), static function ($carry, $item) use ($vendor) {
                    $ofCurrentVendor = $item->getVendor()
                        && $item->getVendor()->getProfileId() === $vendor->getProfileId();

                    return $carry + ($ofCurrentVendor ? $item->getTotal() : 0);
                }, 0);
            } elseif (!$order->getVendor() || $order->getVendor()->getProfileId() !== $vendor->getProfileId()) {
                $result = $order->getChildByVendor($vendor)->getSubtotal();
            }
        }

        return $result;
    }
}
