<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\View\Tabs;

use XCart\Extender\Mapping\Extender;

/**
 * Tabs related to localization
 * @Extender\Mixin
 */
abstract class Localization extends \XLite\View\Tabs\Localization
{
    /**
     * Returns the list of targets where this widget is available
     *
     * @return string[]
     */
    public static function getAllowedTargets()
    {
        $list = array_diff(parent::getAllowedTargets(), ['currency']);
        $list[] = 'currencies';

        return $list;
    }

    /**
     * @return array
     */
    protected function defineTabs()
    {
        $list = parent::defineTabs();
        unset($list['currency']);
        $list['currencies'] = [
            'weight'   => 200,
            'title'    => static::t('Currencies'),
            'template' => 'modules/XC/MultiCurrency/currencies.twig',
        ];

        return $list;
    }
}
