<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\View;

use XCart\Extender\Mapping\Extender;

/**
 * Product price
 * @Extender\Mixin
 */
class Surcharge extends \XLite\View\Surcharge
{
    public const PARAM_NO_CONVERSION = 'noConversion';

    /**
     * Format price as HTML block
     *
     * @param float                 $value             Value
     * @param \XLite\Model\Currency $currency          Currency OPTIONAL
     * @param boolean               $strictFormat      Flag if the price format is strict (trailing zeroes and so on options) OPTIONAL
     * @param boolean               $noValueConversion Do not use value conversion OPTIONAL
     *
     * @return string
     */
    public function formatPriceHTML($value, \XLite\Model\Currency $currency = null, $strictFormat = false, $noValueConversion = false)
    {
        $noConversion = $this->getParam(self::PARAM_NO_CONVERSION) || $noValueConversion ? true : false;

        return parent::formatPriceHTML($value, $currency, $strictFormat, $noConversion);
    }

    /**
     * Define widget parameters
     *
     * @return void
     */
    protected function defineWidgetParams()
    {
        parent::defineWidgetParams();

        $this->widgetParams += [
            self::PARAM_NO_CONVERSION => new \XLite\Model\WidgetParam\TypeBool('No conversion', null)
        ];
    }
}
