<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\View\Order;

use XCart\Extender\Mapping\Extender;
use XC\MultiCurrency\Core\MultiCurrency;

/**
 * Orders search widget
 * @Extender\Mixin
 */
class ListItem extends \XLite\View\Order\ListItem
{
    /**
     * Format price
     *
     * @param float                 $value        Price
     * @param \XLite\Model\Currency $currency     Currency OPTIONAL
     * @param boolean               $strictFormat Flag if the price format is strict (trailing zeroes and so on options) OPTIONAL
     *
     * @return string
     */
    protected function formatOrderPrice($value, \XLite\Model\Currency $currency = null, $strictFormat = false)
    {
        if ($this->getOrder()->isMultiCurrencyOrder()) {
            $value = MultiCurrency::getInstance()->convertValueByRate(
                $value,
                $this->getOrder()->getSelectedMultiCurrencyRate()
            );

            $currency = $this->getOrder()->getSelectedMultiCurrency();
        }

        return static::formatPrice($value, $currency, $strictFormat, true);
    }
}
