<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\View;

/**
 * Product price
 *
 *
 */
class InvoiceChargeWarning extends \XC\MultiCurrency\View\RealChargeWarning
{
    /**
     * Get note
     *
     * @return string
     */
    protected function getSelectedRateText()
    {
        $order = $this->getOrder();

        if (
            isset($order)
            && $order->isMultiCurrencyOrder()
        ) {
            $return = static::t(
                'Note: Order billed in {{currency}}. Exchange rate is {{exchange_rate}}.',
                [
                    'currency' => $this->getDefaultCurrencyText(
                        $order->getCurrency()
                    ),
                    'exchange_rate' => $this->getSelectedCurrencyRateText(
                        $order->getSelectedMultiCurrency(),
                        $order->getSelectedMultiCurrencyRate(),
                        $order->getCurrency()
                    )
                ]
            );
        } else {
            $return = '';
        }

        return $return;
    }
}
