<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\View\FormField\Select\Currency;

use XC\MultiCurrency\Core\MultiCurrency;

/**
 * Customer currency selector
 */
class CustomerCountry extends \XLite\View\FormField\Select\ASelect
{
    /**
     * Return field value
     *
     * @return mixed
     */
    public function getValue()
    {
        return MultiCurrency::getInstance()->getSelectedCountry()->getCode();
    }

    /**
     * Return default options list
     *
     * @return array
     */
    protected function getDefaultOptions()
    {
        $return = [];

        $countries = MultiCurrency::getInstance()->getAvailableCountriesAsArray();

        if (
            is_array($countries)
            && !empty($countries)
        ) {
            foreach ($countries as $country) {
                $return[$country['code']] = $country['country'];
            }
        }

        return $return;
    }

    /**
     * getDefaultLabel
     *
     * @return string
     */
    protected function getDefaultLabel()
    {
        return static::t('Country');
    }

    /**
     * Check if widget is visible
     *
     * @return boolean
     */
    protected function isVisible()
    {
        return MultiCurrency::getInstance()->hasAvailableCountries();
    }
}
