<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\View\FormField\Inline\Input\Checkbox\Switcher;

/**
 * Currency country state switcher
 */
class CurrencyCountry extends \XLite\View\FormField\Inline\Input\Checkbox\Switcher\Enabled
{
    /**
     * Get entity value
     *
     * @return mixed
     */
    protected function getEntityValue()
    {
        $activeCountries = [];

        if (!empty(\XLite\Core\Request::getInstance()->active_currency_id)) {
            $activeCountries = \XLite\Core\Database::getRepo('XC\MultiCurrency\Model\ActiveCurrency')
                ->getActiveCountriesIds(\XLite\Core\Request::getInstance()->active_currency_id);
        }

        return in_array($this->getEntity()->getId(), $activeCountries);
    }
}
