<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\MultiCurrency\Transformer\XLite\Model\Country\Logic\Entity;

use XLite\Model\Country as Source;
use XCart\Logic\Entity\Storefront\Country as Target;
use XCart\Transformer\XLite\Model\Country\Logic\Entity\Storefront\CountryInterface;

class CountryDecorator implements CountryInterface
{
    public function __construct(
        private CountryInterface $inner
    ) {
    }

    public function transform(Source $input): Target
    {
        $dto = $this->inner->transform($input);
        $dto->setActiveCurrency($input->getActiveCurrency()?->getCode());

        return $dto;
    }
}
