<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\MultiCurrency\Transformer\XC\MultiCurrency\Model\ActiveCurrency\Logic\Entity\Storefront;

use XC\MultiCurrency\Model\ActiveCurrency as Source;
use XCart\Logic\Entity\Storefront\Currency as Target;
use XCart\Factory\Logic\Entity\Storefront\CurrencyInterface as Factory;
use XCart\Transformer\XC\MultiCurrency\Model\ActiveCurrency\Logic\Entity\Storefront\CurrencyInterface;

class CurrencyDecorator implements CurrencyInterface
{
    public function __construct(
        private CurrencyInterface $inner,
        private Factory $factory
    ) {
    }

    public function transform(Source $input): Target
    {
        $dto = $this->factory->create();
        $dto->setId($input->getActiveCurrencyId());
        $dto->setCode($input->getCode());
        $dto->setRate($input->getRate());
        $dto->setPrefix($input->getPrefix());
        $dto->setSuffix($input->getSuffix());
        $dto->setPrecision($input->getCurrency()->getE());
        $dto->setDecimalDelimiter($input->getCurrency()->getDecimalDelimiter());
        $dto->setThousandDelimiter($input->getCurrency()->getThousandDelimiter());
        $dto->setDefault($input->getDefaultValue());
        $dto->setCountries(
            $input->getCountries()->map(
                static fn (\XLite\Model\Country $country) => $country->getCode()
            )->toArray()
        );

        return $dto;
    }
}
