<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\Model\Repo;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend ("XC\Geolocation")
 */
class ActiveCurrencyGeolocation extends \XC\MultiCurrency\Model\Repo\ActiveCurrency
{
    /**
     * Get default currency
     *
     * @return \XLite\Model\Currency
     */
    public function getDetectedCurrency()
    {
        $data = \XC\Geolocation\Logic\Geolocation::getInstance()->getLocation(new \XC\Geolocation\Logic\GeoInput\IpAddress());

        $defaultCurrencyId = \XLite\Core\Config::getInstance()->General->shop_currency;
        if (isset($data['country'])) {
            $country = \XLite\Core\Database::getRepo('XLite\Model\Country')->find($data['country']);

            if ($country) {
                if ($country->getActiveCurrency() && $country->getActiveCurrency()->getEnabled()) {
                    $defaultCurrencyId = $country->getActiveCurrency()->getCurrency()->getCurrencyId();
                } elseif ($country->getCurrency() && $country->getCurrency()->isActiveMultiCurrency() && $country->getCurrency()->getActiveCurrency()->getEnabled()) {
                    $defaultCurrencyId = $country->getCurrency()->getCurrencyId();
                }
            }
        }

        $defaultCurrency = \XLite\Core\Database::getRepo('XLite\Model\Currency')
            ->find($defaultCurrencyId);

        return $defaultCurrency;
    }

    /**
     * Get default country code
     *
     * @return \XLite\Model\Country
     */
    public function getDefaultCountry()
    {
        $country = null;

        $data = \XC\Geolocation\Logic\Geolocation::getInstance()->getLocation(new \XC\Geolocation\Logic\GeoInput\IpAddress());

        if (isset($data['country'])) {
            $country = \XLite\Core\Database::getRepo('XLite\Model\Country')->find($data['country']);
        }

        return $country ?: parent::getDefaultCountry();
    }
}
